<?php

// Envoie un mail d'avertissement de la mise à disposition d'Ephata à sa mailing list (ephata@paroisses-saudrune.fr)
// Ce script est exécuté par le cron OVH, tous les vendredi à 20h53 (les minutes c'est pas moi qui décide, c'est OVH !).
// Le cron s'appelle  : "Envoie à la mailing list Ephata" dans la console client OVH.

// La racine du site web
$MYROOT="/home/paroissegq/www";
// La ou se trouve mes scripts
$MYDIR="$MYROOT/abonnements";
// Log des scripts
$MYLOG="$MYDIR/ml_ephata_log.txt";
// Dossier de mise à disposition des ephatas pour la mailing list uniquement
$EPHDIR="$MYROOT/ephata/mailing_list";
// Adresse de la mailing list
$MAILING_LIST="ephata@paroisses-saudrune.fr";
// Pas de réponse à donner à l'avertissement
$NO_REPLY_TO="Ne_pas_répondre@paroisses-saudrune.fr";
// Adresse des modérateurs de la mailing list ephata qui recevront la demande d'approbation
// Ou seront avertis en cas de probléme
$MODERATORS="esther.bernabe31@gmail.com,denis.lalanne@laposte.net";
//$MODERATORS="esther.bernabe31@gmail.com";

// Fonctions de log
function mylog($s) {
  global $MYLOG;
//  echo "$s";

  if (($fp = fopen($MYLOG, 'a+'))) {
    fwrite($fp, $s);
    fclose($fp);
  }
}
// Ajoute un timestamp et un retour chariot au log
function mylogln($s) {
  $ts_log=date("Y-m-d H:i:s");
  mylog("$ts_log : $s\n");
}
parse_str($_SERVER['QUERY_STRING'], $res);
if (isset($res['date'])) {
  mylogln("isset ".$res['date']);
  $sunday=strtotime('next sunday', strtotime($res['date']));
} else {
  $sunday=strtotime('next sunday');
}
//mylogln(var_dump($res);

// Détermine la date du dimanche de la semaine en cours
$ts_sunday=date("Y-m-d", $sunday);
$date_sunday=date("d/m/Y", $sunday);

// Le titre de l'Ephata qui doit être mit à disposition
$next_ephata=glob("$EPHDIR/ephata_*_$ts_sunday.pdf");

// Pour envoyer un mail HTML, l'en-tête Content-type doit être défini
$headers  = "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
// En-têtes additionnels pour empêcher la réponse
$headers .= "From: $NO_REPLY_TO\r\n";
$headers .= 'reply-to: <>';
// Le corps du message est en html
$message = "<html><body>";

// Si le numéro d'ephata est bien disponible on diffuse
if (is_array($next_ephata) && ! empty($next_ephata[0])) {
  // Extrait le numéro
  $num_ephata=preg_replace('/.*ephata_(.*)_'.$ts_sunday.'.pdf/', "$1", $next_ephata[0]);
  // Sujet du message
  $subject="le numéro $num_ephata du dimanche $date_sunday est disponible !";
  // Liste des destinataires de l'avertissement Ephata
  $to=$MAILING_LIST;
  // Corps du message
  $message .= "
Le numéro $num_ephata d'Ephata, daté du $date_sunday est disponible en suivant <a href=\"http://www.paroisses-saudrune.fr/ephata/mailing_list/ephata_{$num_ephata}_$ts_sunday.pdf\">>> ce lien <<</a>.
<br>
Dites autour de vous que l'on peut s'abonner à la mailing-list d'Ephata.<br>
Il suffit d'envoyer un mail ici : ephata-subscribe@paroisses-saudrune.fr
<br><br>
En attendant, bonne lecture !<br>
L'équipe paroissiale.
";
} else { // Sinon on avertis les modérateurs qu'il n'est pas dispo
  // Sujet du message
  $subject="L'ephata du dimanche $date_sunday N'EST PAS disponible ?";
  // Message vers les) éditeur(s) d'Ephata
  $to=$MODERATORS;
  // Corps du message
  $message="
L'Ephata daté du $date_sunday ne semble pas être disponible sur le site web de la paroisse<br>
Quand il le sera, pour relancer l'email d'alerte parution, <a href='http://www.paroisses-saudrune.fr/abonnements/'>suivre ce lien.</a>
<br><br>
Bon travail !<br>
Le webmaster.
";
}

// Clôt le corps du message en html
$message.="<br></body></html>\r\n";
// Trace le sujet dans les logs
mylogln("$subject : $to");
// Envoi effectif de l'email qui va généré une demande d'approbation pour les modérateurs
if (mail($to, $subject, $message, $headers)) {
  mylogln("Email envoyé");
} else mylogln("Livraison email(s) refusée");
?>

