
<?php
/**
 * Allows for images as menu items.
 * Just supply the an image path in the title. The image path will be replaced
 * with an img tag. The description is used as alt text and title.
 * Implements theme_menu_link().
 * Reference: http://chrisshattuck.com/blog/how-use-images-menu-items-drupal-simple-preprocessing-function
 */
function YOUR_THEME_menu_link($variables) {
  $element = &$variables['element'];

  $pattern = '/\S+\.(png|gif|jpg)\b/i';
  if (preg_match($pattern, $element['#title'], $matches) > 0) {
    $element['#title'] = preg_replace($pattern,
      '<img alt = "' . $element['#localized_options']['attributes']['title'] . '" src = "' . url($matches[0]) . '" />',
      $element['#title']);
    $element['#localized_options']['html'] = TRUE;
  }

  return theme_menu_link($variables);
}

YOUR_THEME_menu_link("toto.png");
?>
